/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IntSetting
implements ISetting {
    private int value;
    private int defaultValue;

    public IntSetting(int init) {
        this.value = init;
        this.defaultValue = init;
    }

    public IntSetting(int value, int def) {
        this.value = value;
        this.defaultValue = def;
    }

    public int getValue() {
        return this.value;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutintsetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((TextField)pane.findPaneOfTypeByID("trigger", TextField.class)).setHandler(input -> {
            try {
                this.value = Integer.parseInt(input.getText());
                settingsModuleView.trigger(key);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        TextField field = (TextField)pane.findPaneOfTypeByID("trigger", TextField.class);
        if (!field.getText().equals(String.valueOf(this.value))) {
            field.setText(String.valueOf(this.value));
        }
    }

    @Override
    public void trigger() {
    }

    public void setValue(int value) {
        this.value = value;
    }
}

